#!/bin/bash

if [ ! -d "./test" ]; then
	echo "USAGE: ./tools/test.sh"
	exit 1
fi

function ks_clean()
{
	ks_info "Cleaning..."

	if [ -f "Makefile" ]; then
		make clean
	fi

	rm -f .qmake.stash target_wrapper.sh test

	if [ "$1" == "--full" ]; then
		rm -f Makefile
	fi
}

function ks_info()
{
	echo
	echo "INFO: $1"
	echo
}

ks_info "Validating src/kshutdown.desktop..."

desktop-file-validate --warn-kde "src/kshutdown.desktop"

set -e

for dir in ./test/*; do
	if [ -d "$dir" ]; then
		if [ "$1" == "--clean" ]; then
			ks_info "Cleaning \"$dir\" directory..."

			pushd "$dir"
			ks_clean --full
			popd

			continue
		fi

		ks_info "Testing \"$dir\" directory..."

		pushd "$dir"

		ks_info "Configuring..."
		qmake \
			"CONFIG += testcase" \
			"DEFINES += KS_PURE_QT" \
			"INCLUDEPATH += ../../src" \
			"QT += testlib widgets" \
			"TARGET = test" \
			"VPATH += ../../src" \
			-config debug

		ks_clean

		ks_info "Compiling..."
		make -j2

		ks_info "Running..."
		./test

		ks_clean --full

		popd
	fi
done
