/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.ModuleDependency;
import org.gradle.plugins.ide.idea.model.SingleEntryModuleLibrary;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaCompilerOutput;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaContentRoot;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaDependency;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaDependencyScope;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaModuleDependency;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaSingleEntryLibraryDependency;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaSourceDirectory;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleModuleVersion;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class IdeaModuleBuilderSupport {
    public static @Nullable JavaVersion convertToJavaVersion(@Nullable IdeaLanguageLevel ideaLanguageLevel) {
        if (ideaLanguageLevel == null) {
            return null;
        }
        String languageLevel = ideaLanguageLevel.getLevel();
        return JavaVersion.valueOf((String)languageLevel.replaceFirst("JDK", "VERSION"));
    }

    public static DefaultIdeaContentRoot buildContentRoot(IdeaModule ideaModule) {
        return new DefaultIdeaContentRoot().setRootDirectory(ideaModule.getContentRoot()).setSourceDirectories(IdeaModuleBuilderSupport.buildSourceDirectories(ideaModule.getSourceDirs(), ideaModule.getGeneratedSourceDirs())).setTestDirectories(IdeaModuleBuilderSupport.buildSourceDirectories(ideaModule.getTestSources().getFiles(), ideaModule.getGeneratedSourceDirs())).setResourceDirectories(IdeaModuleBuilderSupport.buildSourceDirectories(ideaModule.getResourceDirs(), ideaModule.getGeneratedSourceDirs())).setTestResourceDirectories(IdeaModuleBuilderSupport.buildSourceDirectories(ideaModule.getTestResources().getFiles(), ideaModule.getGeneratedSourceDirs())).setExcludeDirectories(ideaModule.getExcludeDirs());
    }

    private static Set<DefaultIdeaSourceDirectory> buildSourceDirectories(Set<File> sourceDirs, Set<File> generatedSourceDirs) {
        LinkedHashSet<DefaultIdeaSourceDirectory> out = new LinkedHashSet<DefaultIdeaSourceDirectory>();
        for (File s : sourceDirs) {
            DefaultIdeaSourceDirectory sourceDirectory = new DefaultIdeaSourceDirectory().setDirectory(s);
            if (generatedSourceDirs.contains(s)) {
                sourceDirectory.setGenerated(true);
            }
            out.add(sourceDirectory);
        }
        return out;
    }

    public static DefaultIdeaCompilerOutput buildCompilerOutput(IdeaModule ideaModule) {
        return new DefaultIdeaCompilerOutput().setInheritOutputDirs(ideaModule.getInheritOutputDirs() != null ? ideaModule.getInheritOutputDirs() : false).setOutputDir(ideaModule.getOutputDir()).setTestOutputDir(ideaModule.getTestOutputDir());
    }

    public static List<DefaultIdeaDependency> buildDependencies(Set<Dependency> resolvedDependencies) {
        LinkedList<DefaultIdeaDependency> dependencies = new LinkedList<DefaultIdeaDependency>();
        for (Dependency dependency : resolvedDependencies) {
            SingleEntryModuleLibrary d;
            if (dependency instanceof SingleEntryModuleLibrary) {
                d = (SingleEntryModuleLibrary)dependency;
                dependencies.add((DefaultIdeaDependency)IdeaModuleBuilderSupport.ideaSingleEntryLibraryDependencyFor(d));
                continue;
            }
            if (!(dependency instanceof ModuleDependency)) continue;
            d = (ModuleDependency)dependency;
            dependencies.add((DefaultIdeaDependency)IdeaModuleBuilderSupport.ideaModuleDependencyFor((ModuleDependency)d));
        }
        return dependencies;
    }

    private static DefaultIdeaSingleEntryLibraryDependency ideaSingleEntryLibraryDependencyFor(SingleEntryModuleLibrary d) {
        DefaultIdeaSingleEntryLibraryDependency defaultDependency = new DefaultIdeaSingleEntryLibraryDependency().setFile(d.getLibraryFile()).setSource(d.getSourceFile()).setJavadoc(d.getJavadocFile()).setScope((IdeaDependencyScope)new DefaultIdeaDependencyScope(d.getScope())).setExported(Boolean.valueOf(d.isExported()));
        if (d.getModuleVersion() != null) {
            defaultDependency.setGradleModuleVersion((GradleModuleVersion)new DefaultGradleModuleVersion(d.getModuleVersion()));
        }
        return defaultDependency;
    }

    private static DefaultIdeaModuleDependency ideaModuleDependencyFor(ModuleDependency d) {
        return new DefaultIdeaModuleDependency(d.getName()).setExported(d.isExported()).setScope((IdeaDependencyScope)new DefaultIdeaDependencyScope(d.getScope()));
    }
}

