/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;

public class DefaultToolchainConfiguration
implements ToolchainConfiguration {
    private Collection<String> javaInstallationsFromEnvironment;
    private Collection<String> installationsFromPaths;
    private boolean autoDetectEnabled;
    private boolean downloadEnabled;
    private File intellijInstallationDirectory;
    private final SystemProperties systemProperties;
    private final Map<String, String> environment;

    @Inject
    public DefaultToolchainConfiguration() {
        this(OperatingSystem.current(), SystemProperties.getInstance(), System.getenv());
    }

    @VisibleForTesting
    DefaultToolchainConfiguration(OperatingSystem os, SystemProperties systemProperties, Map<String, String> environment) {
        this.systemProperties = systemProperties;
        this.environment = environment;
        this.autoDetectEnabled = true;
        this.downloadEnabled = true;
        this.intellijInstallationDirectory = this.defaultJdksDirectory(os);
        this.javaInstallationsFromEnvironment = Collections.emptyList();
        this.installationsFromPaths = Collections.emptyList();
    }

    @Override
    public Collection<String> getJavaInstallationsFromEnvironment() {
        return this.javaInstallationsFromEnvironment;
    }

    @Override
    public void setJavaInstallationsFromEnvironment(Collection<String> javaInstallationsFromEnvironment) {
        this.javaInstallationsFromEnvironment = javaInstallationsFromEnvironment;
    }

    @Override
    public Collection<String> getInstallationsFromPaths() {
        return this.installationsFromPaths;
    }

    @Override
    public void setInstallationsFromPaths(Collection<String> installationsFromPaths) {
        this.installationsFromPaths = installationsFromPaths;
    }

    @Override
    public boolean isAutoDetectEnabled() {
        return this.autoDetectEnabled;
    }

    @Override
    public void setAutoDetectEnabled(boolean autoDetectEnabled) {
        this.autoDetectEnabled = autoDetectEnabled;
    }

    @Override
    public boolean isDownloadEnabled() {
        return this.downloadEnabled;
    }

    @Override
    public void setDownloadEnabled(boolean enabled) {
        this.downloadEnabled = enabled;
    }

    @Override
    public File getAsdfDataDirectory() {
        String asdfEnvVar = this.environment.get("ASDF_DATA_DIR");
        if (asdfEnvVar != null) {
            return new File(asdfEnvVar);
        }
        return new File(this.systemProperties.getUserHome(), ".asdf");
    }

    @Override
    public File getIntelliJdkDirectory() {
        return this.intellijInstallationDirectory;
    }

    @Override
    public void setIntelliJdkDirectory(File intellijInstallationDirectory) {
        this.intellijInstallationDirectory = intellijInstallationDirectory;
    }

    private File defaultJdksDirectory(OperatingSystem os) {
        if (os.isMacOsX()) {
            return new File(this.systemProperties.getUserHome(), "Library/Java/JavaVirtualMachines");
        }
        return new File(this.systemProperties.getUserHome(), ".jdks");
    }

    @Override
    public File getJabbaHomeDirectory() {
        String jabbaHome = this.environment.get("JABBA_HOME");
        if (jabbaHome != null) {
            return new File(jabbaHome);
        }
        return null;
    }

    @Override
    public File getSdkmanCandidatesDirectory() {
        String asdfEnvVar = this.environment.get("SDKMAN_CANDIDATES_DIR");
        if (asdfEnvVar != null) {
            return new File(asdfEnvVar);
        }
        return new File(this.systemProperties.getUserHome(), ".sdkman/candidates");
    }
}

